/*
 * Decompiled with CFR 0.152.
 */
package com.ishland.c2me.opts.dfc.common.ast.noise;

import com.ishland.c2me.base.mixin.access.IDensityFunctionTypesWeirdScaledSamplerRarityValueMapper;
import com.ishland.c2me.base.mixin.access.IDensityFunctionsCaveScaler;
import com.ishland.c2me.opts.dfc.common.ast.AstNode;
import com.ishland.c2me.opts.dfc.common.ast.AstTransformer;
import com.ishland.c2me.opts.dfc.common.ast.EvalType;
import com.ishland.c2me.opts.dfc.common.gen.BytecodeGen;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_6910;
import net.minecraft.class_6916;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;

public class DFTWeirdScaledSamplerNode
implements AstNode {
    private final AstNode input;
    private final class_6910.class_7270 noise;
    private final class_6916.class_6944.class_7048 mapper;

    public DFTWeirdScaledSamplerNode(AstNode input, class_6910.class_7270 noise, class_6916.class_6944.class_7048 mapper) {
        this.input = Objects.requireNonNull(input);
        this.noise = Objects.requireNonNull(noise);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public double evalSingle(int x, int y, int z, EvalType type) {
        double v = this.input.evalSingle(x, y, z, type);
        double d = ((IDensityFunctionTypesWeirdScaledSamplerRarityValueMapper)this.mapper).getScaleFunction().get(v);
        return d * Math.abs(this.noise.method_42356((double)x / d, (double)y / d, (double)z / d));
    }

    @Override
    public void evalMulti(double[] res, int[] x, int[] y, int[] z, EvalType type) {
        this.input.evalMulti(res, x, y, z, type);
        for (int i = 0; i < res.length; ++i) {
            double d = ((IDensityFunctionTypesWeirdScaledSamplerRarityValueMapper)this.mapper).getScaleFunction().get(res[i]);
            res[i] = d * Math.abs(this.noise.method_42356((double)x[i] / d, (double)y[i] / d, (double)z[i] / d));
        }
    }

    @Override
    public AstNode[] getChildren() {
        return new AstNode[]{this.input};
    }

    @Override
    public AstNode transform(AstTransformer transformer) {
        AstNode input = this.input.transform(transformer);
        if (input == this.input) {
            return transformer.transform(this);
        }
        return transformer.transform(new DFTWeirdScaledSamplerNode(input, this.noise, this.mapper));
    }

    @Override
    public void doBytecodeGenSingle(BytecodeGen.Context context, InstructionAdapter m, BytecodeGen.Context.LocalVarConsumer localVarConsumer) {
        String inputMethod = context.newSingleMethod(this.input);
        String noiseField = context.newField(class_6910.class_7270.class, this.noise);
        int scale = localVarConsumer.createLocalVariable("scale", Type.DOUBLE_TYPE.getDescriptor());
        context.callDelegateSingle(m, inputMethod);
        switch (this.mapper) {
            case field_37066: {
                m.invokestatic(Type.getInternalName(IDensityFunctionsCaveScaler.class), "invokeScaleTunnels", Type.getMethodDescriptor((Type)Type.DOUBLE_TYPE, (Type[])new Type[]{Type.DOUBLE_TYPE}), true);
                break;
            }
            case field_37067: {
                m.invokestatic(Type.getInternalName(IDensityFunctionsCaveScaler.class), "invokeScaleCaves", Type.getMethodDescriptor((Type)Type.DOUBLE_TYPE, (Type[])new Type[]{Type.DOUBLE_TYPE}), true);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unknown mapper %s", this.mapper));
            }
        }
        m.store(scale, Type.DOUBLE_TYPE);
        m.load(0, InstructionAdapter.OBJECT_TYPE);
        m.getfield(context.className, noiseField, Type.getDescriptor(class_6910.class_7270.class));
        m.load(1, Type.INT_TYPE);
        m.cast(Type.INT_TYPE, Type.DOUBLE_TYPE);
        m.load(scale, Type.DOUBLE_TYPE);
        m.div(Type.DOUBLE_TYPE);
        m.load(2, Type.INT_TYPE);
        m.cast(Type.INT_TYPE, Type.DOUBLE_TYPE);
        m.load(scale, Type.DOUBLE_TYPE);
        m.div(Type.DOUBLE_TYPE);
        m.load(3, Type.INT_TYPE);
        m.cast(Type.INT_TYPE, Type.DOUBLE_TYPE);
        m.load(scale, Type.DOUBLE_TYPE);
        m.div(Type.DOUBLE_TYPE);
        m.invokevirtual(Type.getInternalName(class_6910.class_7270.class), FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_6910$class_7270", "method_42356", "(DDD)D"), "(DDD)D", false);
        m.invokestatic(Type.getInternalName(Math.class), "abs", "(D)D", false);
        m.load(scale, Type.DOUBLE_TYPE);
        m.mul(Type.DOUBLE_TYPE);
        m.areturn(Type.DOUBLE_TYPE);
    }

    @Override
    public void doBytecodeGenMulti(BytecodeGen.Context context, InstructionAdapter m, BytecodeGen.Context.LocalVarConsumer localVarConsumer) {
        String inputMethod = context.newMultiMethod(this.input);
        String noiseField = context.newField(class_6910.class_7270.class, this.noise);
        context.callDelegateMulti(m, inputMethod);
        context.doCountedLoop(m, localVarConsumer, idx -> {
            int scale = localVarConsumer.createLocalVariable("scale", Type.DOUBLE_TYPE.getDescriptor());
            m.load(1, InstructionAdapter.OBJECT_TYPE);
            m.load(idx, Type.INT_TYPE);
            m.load(1, InstructionAdapter.OBJECT_TYPE);
            m.load(idx, Type.INT_TYPE);
            m.aload(Type.DOUBLE_TYPE);
            switch (this.mapper) {
                case field_37066: {
                    m.invokestatic(Type.getInternalName(IDensityFunctionsCaveScaler.class), "invokeScaleTunnels", Type.getMethodDescriptor((Type)Type.DOUBLE_TYPE, (Type[])new Type[]{Type.DOUBLE_TYPE}), true);
                    break;
                }
                case field_37067: {
                    m.invokestatic(Type.getInternalName(IDensityFunctionsCaveScaler.class), "invokeScaleCaves", Type.getMethodDescriptor((Type)Type.DOUBLE_TYPE, (Type[])new Type[]{Type.DOUBLE_TYPE}), true);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unknown mapper %s", this.mapper));
                }
            }
            m.store(scale, Type.DOUBLE_TYPE);
            m.load(0, InstructionAdapter.OBJECT_TYPE);
            m.getfield(context.className, noiseField, Type.getDescriptor(class_6910.class_7270.class));
            m.load(2, InstructionAdapter.OBJECT_TYPE);
            m.load(idx, Type.INT_TYPE);
            m.aload(Type.INT_TYPE);
            m.cast(Type.INT_TYPE, Type.DOUBLE_TYPE);
            m.load(scale, Type.DOUBLE_TYPE);
            m.div(Type.DOUBLE_TYPE);
            m.load(3, InstructionAdapter.OBJECT_TYPE);
            m.load(idx, Type.INT_TYPE);
            m.aload(Type.INT_TYPE);
            m.cast(Type.INT_TYPE, Type.DOUBLE_TYPE);
            m.load(scale, Type.DOUBLE_TYPE);
            m.div(Type.DOUBLE_TYPE);
            m.load(4, InstructionAdapter.OBJECT_TYPE);
            m.load(idx, Type.INT_TYPE);
            m.aload(Type.INT_TYPE);
            m.cast(Type.INT_TYPE, Type.DOUBLE_TYPE);
            m.load(scale, Type.DOUBLE_TYPE);
            m.div(Type.DOUBLE_TYPE);
            m.invokevirtual(Type.getInternalName(class_6910.class_7270.class), FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_6910$class_7270", "method_42356", "(DDD)D"), "(DDD)D", false);
            m.invokestatic(Type.getInternalName(Math.class), "abs", "(D)D", false);
            m.load(scale, Type.DOUBLE_TYPE);
            m.mul(Type.DOUBLE_TYPE);
            m.astore(Type.DOUBLE_TYPE);
        });
        m.areturn(Type.VOID_TYPE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DFTWeirdScaledSamplerNode that = (DFTWeirdScaledSamplerNode)o;
        return Objects.equals(this.input, that.input) && Objects.equals(this.noise, that.noise) && this.mapper == that.mapper;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getClass().hashCode();
        result = 31 * result + this.input.hashCode();
        result = 31 * result + this.noise.hashCode();
        result = 31 * result + this.mapper.hashCode();
        return result;
    }

    @Override
    public boolean relaxedEquals(AstNode o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DFTWeirdScaledSamplerNode that = (DFTWeirdScaledSamplerNode)o;
        return this.input.relaxedEquals(that.input) && this.mapper == that.mapper;
    }

    @Override
    public int relaxedHashCode() {
        int result = 1;
        result = 31 * result + this.getClass().hashCode();
        result = 31 * result + this.input.relaxedHashCode();
        result = 31 * result + this.mapper.hashCode();
        return result;
    }
}

